<?php
/**
 * @link       https://www.themepunch.com
 * @package    Revslider_Login_Addon
 * @subpackage Revslider_Login_Addon/includes
 * @author     ThemePunch <info@themepunch.com>
 */
class Revslider_Login_Addon {

	protected $loader;
	protected $plugin_name;
	protected $version;


	public function __construct() {

		$this->plugin_name = 'revslider-login-addon';
		$this->version = REV_ADDON_LOGIN_VERSION;

		$this->load_dependencies();
		$this->set_locale();

		if(is_admin()) {
			$this->define_admin_hooks();
		}else {
			$enabled = get_option('revslider_login_enabled');
			if(!empty($enabled)) $this->define_public_hooks();
		}

	}

	/**
	 * Load the required dependencies for this plugin.
	 */
	private function load_dependencies() {
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/class-revslider-login-addon-admin.php';
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'public/class-revslider-login-addon-public.php';
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-revslider-login-addon-update.php';
	}

	private function set_locale() {
		add_action('after_setup_theme', array($this, 'load_plugin_textdomain'), 10, 1);
	}

	public function load_plugin_textdomain() {
		load_plugin_textdomain($this->get_plugin_name(), false, dirname( dirname( plugin_basename( __FILE__ ) ) ) . '/languages/');
	}

	/**
	 * Register all of the hooks related to the admin area functionality of the plugin.
	 **/
	private function define_admin_hooks() {

		$plugin_admin = new Revslider_Login_Addon_Admin( $this->get_plugin_name(), $this->get_version() );
		$update_admin = new RevAddOnLoginUpdate(REV_ADDON_LOGIN_VERSION);

		// $this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_styles' );
		add_action('admin_enqueue_scripts', array($plugin_admin, 'enqueue_scripts'), 10, 1);

		//updates
		add_filter('pre_set_site_transient_update_plugins', array($update_admin, 'set_update_transient'), 10, 1);
		add_filter('plugins_api', array($update_admin, 'set_updates_api_results'), 10, 3);

		//admin page
		add_action('revslider_do_ajax', array($plugin_admin, 'do_ajax'), 10, 2);

		//meta placeholder for login form
		add_action('rev_slider_insert_gallery_meta_row', array($plugin_admin, 'add_placeholder'), 10, 1);

		//build js global var for activation
		add_action('revslider_activate_addon', array($plugin_admin, 'get_var'), 10, 2);
	}

	/**
	 * Register all of the hooks related to the public-facing functionality of the plugin.
	 */
	private function define_public_hooks() {
		$plugin_public = new Revslider_Login_Addon_Public( $this->get_plugin_name(), $this->get_version() );

		// add shortcodes for forms display
		add_action('init', array($plugin_public, 'add_shortcodes'), 10, 1);
		add_action('login_form_login', array($plugin_public, 'redirect_to_custom_login'), 10, 1);

		// login error message
		add_action('wp_login_failed', array($plugin_public, 'front_end_login_fail'), 10, 1);

		// overtake lost password
		$revslider_login_addon_values = array();
		parse_str(get_option('revslider_login_addon'), $revslider_login_addon_values);
		//var_dump($revslider_login_addon_values);
		$revslider_login_addon_values['revslider-login-lost-password-overtake'] = isset($revslider_login_addon_values['revslider-login-lost-password-overtake']) ? $revslider_login_addon_values['revslider-login-lost-password-overtake'] : '0';
	    if($revslider_login_addon_values['revslider-login-lost-password-overtake']){
			add_action('login_form_lostpassword', array($plugin_public, 'redirect_to_custom_lostpassword'), 10, 1);
	    }
		
		// replace meta with shortcode
		add_filter('revslider_modify_layer_text', array($plugin_public, 'rev_addon_insert_meta'), 10, 2);
	}

	public function get_plugin_name() {
		return $this->plugin_name;
	}

	public function get_loader() {
		return $this->loader;
	}

	public function get_version() {
		return $this->version;
	}

}
